<?php
/**
 * @package SCREENREADER::plugins::system
 * @subpackage libraries
 * @subpackage fields
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

/**
 * Form Field for menu tree
 *
 * @package SCREENREADER::plugins::system
 * @subpackage libraries
 * @subpackage fields
 * @since 2.4
 */
class JFormFieldLanguageMultiselect extends ListField {
	/**
	 * The form field type.
	 *
	 * @var string
	 * @since 1.7.0
	 */
	protected $type = 'LanguageMultiselect';

	/**
	 * Method to get the field options.
	 *
	 * @return array The field option objects.
	 *        
	 * @since 1.7.0
	 */
	protected function getOptions() {
		// Initialize some field attributes.
		$client = ( string ) $this->element ['client'];

		if ($client !== 'site' && $client !== 'administrator') {
			$client = 'site';
		}

		// Make sure the languages are sorted base on locale instead of random sorting
		$languages = LanguageHelper::createLanguageList ( $this->value, \constant ( 'JPATH_' . strtoupper ( $client ) ), true, true );

		if (\count ( $languages ) > 1) {
			usort ( $languages, function ($a, $b) {
				return strcmp ( $a ['value'], $b ['value'] );
			} );
		}

		$noActiveOption = HTMLHelper::_ ( 'select.option', '0', Text::_ ( 'PLG_SCREENREADER_NOEXCLUSION' ) );
		array_unshift ( $languages, $noActiveOption );

		// Merge any additional options in the XML definition.
		$options = array_merge ( parent::getOptions (), $languages );

		return $options;
	}
}
