<?php

/**
 * @package         EngageBox
 * @version         7.0.2 Pro
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\GroupedlistField;

class JFormFieldEBAnimationOut extends GroupedlistField
{
    protected $layout = 'joomla.form.field.groupedlist-fancy-select';
	protected $default = 'fadeOut';

    /**
     * Method to get a list of options for a list input.
     *
     * @return      array           An array of options.
     */
    protected function getGroups()
    {
        $data = [
			'Attention' => [
				'hinge' 	=> 'Hinge',
				'rollOut' 	=> 'Roll Out',
			],
			'Classic' => [
				'fadeOut' => 'Fade Out',
				'zoomOut' => 'Zoom Out',
			],
			
			'Back Exits' => [
				'backOutDown'  => 'Back Out to Bottom',
				'backOutUp'    => 'Back Out to Top',
				'backOutLeft'  => 'Back Out to Left',
				'backOutRight' => 'Back Out to Right',
			],
			'Flip' => [
				'flip' 		=> 'Flip Out',
				'flipOutX'  => 'Flip Out Horizontal',
				'flipOutY'  => 'Flip Out Vertical',
			],
			'Bouncing Exits' => [
				'bounceOut' 	 => 'Bounce Out',
				'bounceOutDown'  => 'Bounce Out to Bottom',
				'bounceOutUp' 	 => 'Bounce Out to Top',
				'bounceOutLeft'  => 'Bounce Out to Left',
				'bounceOutRight' => 'Bounce Out to Right',
			],
			'Slide' => [
				'slideOutDown'  	 => 'Slide Out to Bottom',
				'slideOutUp' 		 => 'Slide Out to Top',
				'slideOutLeft' 		 => 'Slide Out to Left',
				'slideOutRight' 	 => 'Slide Out to Right',
				'fadeOutUp' 		 => 'Slide Out to Top & Fade Out',
				'fadeOutDown' 		 => 'Slide Out to Bottom & Fade Out',
				'fadeOutLeft' 		 => 'Slide Out to Left & Fade Out',
				'fadeOutRight' 		 => 'Slide Out to Right & Fade Out',
				'fadeOutUpBig' 		 => 'Big Slide Out to Top & Fade Out',
				'fadeOutDownBig' 	 => 'Big Slide Out to Bottom & Fade Out',
				'fadeOutLeftBig' 	 => 'Big Slide Out to Left & Fade Out',
				'fadeOutRightBig' 	 => 'Big Slide Out to Right & Fade Out',
				'lightSpeedOutRight' => 'Lightspeed Slide Out to Right',
				'lightSpeedOutLeft'  => 'Lightspeed Slide Out to Left',
			],
			
		];

        $groups = [];

        foreach ($data as $groupKey => $value)
        {
            foreach ($value as $_key => $_value)
			{
				$groupLabel = '';
				
				$groupLabel = Text::_($groupKey);
				
				
                $groups[$groupLabel][] = HTMLHelper::_('select.option', $_key, $_value);
			}
        }

        return $groups;
    }
	
    protected function getInput()
    {
		$class = (string) $this->element['class'];

		$search_placeholder = (string) $this->element['search_placeholder'];
		if ($search_placeholder)
		{
			$this->class = $class . '" search-placeholder="' . Text::_($search_placeholder);
		}
		else
		{
			$this->class = $class;
		}

		return parent::getInput();
	}
}